<?php
/*
Plugin Name: Divi Sticky Sections
Description: Create sticky overlapping/cascading sections with this lightweight plugin. Inspired and powered by the position:sticky polyfill: https://github.com/filamentgroup/fixed-sticky
Author: Sean Barton (Tortoise IT)
Author URI: http://www.tortoise-it.co.uk/
Version: 1.0

Changelog:

V1.0 - 7/4/17
- initial release

//https://github.com/filamentgroup/fixed-sticky
*/

add_action('wp_enqueue_scripts', 'sb_dss_enqueue_scripts');

function sb_dss_enqueue_scripts() {
	$css_url = trailingslashit(plugin_dir_url( __FILE__ )) . 'style.css';
	$css2_url = trailingslashit(plugin_dir_url( __FILE__ )) . 'fixedsticky.css';
	$js_url = trailingslashit(plugin_dir_url( __FILE__ )) . 'fixedsticky.js';
	
	wp_enqueue_script('jquery');
	wp_enqueue_style('sb_dss_css', $css_url);
	wp_enqueue_style('dult2_css', $css2_url);
	wp_enqueue_style('sb_dss_js', $js_url);
}

?>